/*****************************************************************************
 *   target.h:  Header file for NXP LPC23xx/24xx Family Microprocessors
 *
 *   Copyright(C) 2006, NXP Semiconductor
 *   All rights reserved.
 *
 *   History
 *   2006.09.20  ver 1.00    Prelimnary version, first Release
 *
******************************************************************************/
#ifndef __TARGET_H 
#define __TARGET_H

#ifdef __cplusplus
   extern "C" {
#endif

/* Only choose one of them below, by default, it's Keil MCB2300 */
#define ENG_BOARD_LPC24XX				0
#define KEIL_BOARD_LPC23XX				1
#define EA_BOARD_LPC24XX				0
#define IAR_BOARD_LPC23XX				0

/* On EA and IAR boards, they use Micrel PHY.
   on ENG and KEIL boards, they use National PHY */
#define NATIONAL_PHY			1
#define MICREL_PHY				2

/*ʱƵҪlpc2300.sӦ޸ */
/*Fosc=12MHz, M=12, N=1 => Fcco=288MHz, 
	CCLK=288/5=57.6MHz, PCLK=CCLK/4=14.4MHz*/
#if 0
#define Fosc	12000000
#define Fcclk	57600000
#define Fcco	288000000
#define Fpclk	14400000
#endif
/*Fosc=12MHz, M=12, N=1 => Fcco=288MHz, 
	CCLK=288/6=48MHz, PCLK=CCLK/4=12MHz*/
#if 1
#define Fosc	12000000
#define Fcclk	48000000
#define Fcco	288000000
#define Fpclk	12000000
#endif


#ifdef __cplusplus
   }
#endif
 
#endif /* end __TARGET_H */
/******************************************************************************
**                            End Of File
******************************************************************************/
